//  Copyright (c) CNES  2008
//
//  This software is part of CelestLab, a CNES toolbox for Scilab
//
//  This software is governed by the CeCILL  license under French law and
//  abiding by the rules of distribution of free software.  You can  use,
//  modify and/ or redistribute the software under the terms of the CeCILL
//  license as circulated by CEA, CNRS and INRIA at the following URL
//  'http://www.cecill.info'.

function AT = %hm_t(A)
// LAST UPDATE
// 22/02/2007






// Declarations:


// Code:

[l c n]=size(A);
if (l==3 & c==3) then
  AT = hypermat([l c n],[A(1,1,:); A(1,2,:); A(1,3,:); ...
         A(2,1,:); A(2,2,:); A(2,3,:); ...
       A(3,1,:); A(3,2,:); A(3,3,:)]);
else
  AT=zeros(c,l*n); vA=A(:);
  for l0=1:l AT(:,[l0:l:$])=matrix(vA(l0:l:$),[c n]); end,
  AT=matrix(AT,[c l n]);
  //CL__error("verifier dims des hypermat. en entree (3 x 3 x N)");
end

endfunction
